/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.installationgroup;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.installer.console.AbstractConsolePanel;
import com.izforge.izpack.installer.console.ConsolePanel;
import com.izforge.izpack.installer.panel.PanelView;
import com.izforge.izpack.panels.installationgroup.GroupData;
import com.izforge.izpack.panels.installationgroup.InstallationGroupPanel;
import com.izforge.izpack.panels.installationgroup.InstallationGroupPanelAutomationHelper;
import com.izforge.izpack.panels.installationgroup.InstallationGroups;
import com.izforge.izpack.util.Console;
import com.izforge.izpack.util.PlatformModelMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;

public class InstallationGroupConsolePanel
extends AbstractConsolePanel
implements ConsolePanel {
    private static final transient Logger logger = Logger.getLogger(InstallationGroupPanel.class.getName());
    private static final String NOT_SELECTED = "Not Selected";
    private static final String DONE = "Done!";
    private static final String SPACE = " ";
    private final Prompt prompt;
    private final AutomatedInstallData automatedInstallData;
    private final PlatformModelMatcher matcher;
    private GroupData[] rows;

    public InstallationGroupConsolePanel(PanelView<ConsolePanel> panel, Prompt prompt, AutomatedInstallData automatedInstallData, PlatformModelMatcher matcher) {
        super(panel);
        this.prompt = prompt;
        this.automatedInstallData = automatedInstallData;
        this.matcher = matcher;
    }

    @Override
    public boolean run(InstallData installData, Properties properties) {
        return true;
    }

    @Override
    public boolean run(InstallData installData, Console console) {
        this.printHeadLine(installData, console);
        this.automatedInstallData.setAvailablePacks(new ArrayList<Pack>());
        for (Pack pack : this.automatedInstallData.getAllPacks()) {
            if (!this.matcher.matchesCurrentPlatform(pack.getOsConstraints())) continue;
            this.automatedInstallData.getAvailablePacks().add(pack);
        }
        HashMap<String, GroupData> installGroups = InstallationGroups.getInstallGroups(this.automatedInstallData);
        if (installGroups.size() == 0) {
            console.prompt("Skip InstallGroup selection", new String[]{"Yes", "No"}, "Yes");
            return false;
        }
        ArrayList<GroupData> sortedGroups = new ArrayList<GroupData>(installGroups.values());
        Collections.sort(sortedGroups, InstallationGroups.BY_SORT_KEY);
        GroupData selected = this.selectGroup(sortedGroups);
        while (selected == null) {
            this.out(Prompt.Type.ERROR, "Must select an option");
            selected = this.selectGroup(sortedGroups);
        }
        this.automatedInstallData.setVariable("INSTALL_GROUP", selected.name);
        logger.fine("Added variable INSTALL_GROUP=" + selected.name);
        this.setSelectedPacksBySelectedGroup(selected);
        this.rows = new GroupData[installGroups.size()];
        int count = 0;
        Iterator i$ = sortedGroups.iterator();
        while (i$.hasNext()) {
            GroupData gd;
            this.rows[count] = gd = (GroupData)i$.next();
            ++count;
        }
        this.out(Prompt.Type.INFORMATION, DONE);
        return this.promptEndPanel(installData, console);
    }

    @Override
    public void createInstallationRecord(IXMLElement panelRoot) {
        InstallationGroupPanelAutomationHelper helper = new InstallationGroupPanelAutomationHelper();
        this.automatedInstallData.setAttribute("GroupData", this.rows);
        helper.createInstallationRecord(this.automatedInstallData, panelRoot);
    }

    protected void setSelectedPacksBySelectedGroup(GroupData selected) {
        logger.fine("data=" + selected.name);
        Iterator<Pack> iter = this.automatedInstallData.getAvailablePacks().iterator();
        while (iter.hasNext()) {
            Pack pack = iter.next();
            pack.setDependants(null);
            if (selected.packNames.contains(pack.getName())) continue;
            iter.remove();
            logger.fine("Removed available pack: " + pack.getName());
        }
        this.automatedInstallData.getSelectedPacks().clear();
        this.automatedInstallData.getSelectedPacks().addAll(this.automatedInstallData.getAvailablePacks());
    }

    private GroupData selectGroup(List<GroupData> options) {
        GroupData selected = null;
        for (GroupData groupData : options) {
            if (selected != null) {
                this.out(Prompt.Type.INFORMATION, groupData.name + SPACE + NOT_SELECTED);
                continue;
            }
            if (!this.askUser(groupData.name)) continue;
            selected = groupData;
        }
        return selected;
    }

    private void out(Prompt.Type type, String message) {
        this.prompt.message(type, message);
    }

    private boolean askUser(String message) {
        return Prompt.Option.YES == this.prompt.confirm(Prompt.Type.QUESTION, message, Prompt.Options.YES_NO);
    }
}

