/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.installationgroup;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.panels.installationgroup.GroupData;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Logger;

public class InstallationGroups {
    private static final transient Logger logger = Logger.getLogger(InstallationGroups.class.getName());
    public static final Comparator<GroupData> BY_SORT_KEY = new Comparator<GroupData>(){

        @Override
        public int compare(GroupData o1, GroupData o2) {
            return o1.sortKey.compareTo(o2.sortKey);
        }
    };

    public static HashMap<String, GroupData> getInstallGroups(AutomatedInstallData automatedInstallData) {
        HashMap<String, Pack> packsByName = new HashMap<String, Pack>();
        HashMap<String, GroupData> installGroups = new HashMap<String, GroupData>();
        for (Pack pack : automatedInstallData.getAvailablePacks()) {
            packsByName.put(pack.getName(), pack);
            Set<String> groups = pack.getInstallGroups();
            logger.fine("Pack: " + pack.getName() + ", installGroups: " + groups);
            for (String group : groups) {
                GroupData data = installGroups.get(group);
                if (data != null) continue;
                String description = InstallationGroups.getGroupDescription(group, automatedInstallData);
                String sortKey = InstallationGroups.getGroupSortKey(group, automatedInstallData);
                data = new GroupData(group, description, sortKey);
                installGroups.put(group, data);
            }
        }
        logger.fine("Found installGroups: " + installGroups.keySet());
        for (GroupData data : installGroups.values()) {
            logger.fine("Adding dependents for: " + data.name);
            for (Pack pack : automatedInstallData.getAvailablePacks()) {
                Set<String> groups = pack.getInstallGroups();
                if (groups.size() != 0 && !groups.contains(data.name) || data.packNames.contains(pack.getName())) continue;
                data.addDependents(pack, packsByName);
            }
            logger.fine("Completed dependents for: " + data);
        }
        return installGroups;
    }

    public static String getGroupSortKey(String group, AutomatedInstallData automatedInstallData) {
        String key = "InstallationGroupPanel.sortKey." + group;
        String sortKey = automatedInstallData.getVariable(key);
        if (sortKey == null) {
            sortKey = group;
        }
        try {
            sortKey = URLDecoder.decode(sortKey, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.warning("Failed to convert sortKey" + e.getMessage());
        }
        return sortKey;
    }

    public static String getGroupDescription(String group, AutomatedInstallData automatedInstallData) {
        String html;
        String description = null;
        String key = "InstallationGroupPanel.description." + group;
        String htmlKey = key + ".html";
        description = htmlKey.equalsIgnoreCase(html = InstallationGroups.getString(automatedInstallData, htmlKey)) ? InstallationGroups.getString(automatedInstallData, key) : html;
        if (description == null || key.equalsIgnoreCase(description)) {
            description = automatedInstallData.getVariable(key);
        }
        if (description == null) {
            description = group + " installation";
        }
        try {
            description = URLDecoder.decode(description, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.warning("Failed to convert description: " + e.getMessage());
        }
        return description;
    }

    public static String getLocalizedGroupName(String group, AutomatedInstallData automatedInstallData) {
        String html;
        String gname = null;
        String key = "InstallationGroupPanel.group." + group;
        String htmlKey = key + ".html";
        gname = htmlKey.equalsIgnoreCase(html = InstallationGroups.getString(automatedInstallData, htmlKey)) ? InstallationGroups.getString(automatedInstallData, key) : html;
        if (gname == null || key.equalsIgnoreCase(gname)) {
            gname = automatedInstallData.getVariable(key);
        }
        if (gname == null) {
            gname = group;
        }
        try {
            gname = URLDecoder.decode(gname, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.warning("Failed to convert localized group name: " + e.getMessage());
        }
        return gname;
    }

    protected static String getString(AutomatedInstallData automatedInstallData, String key) {
        return automatedInstallData.getMessages().get(key, new Object[0]);
    }
}

